///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//  Copyright  NetworkDLS 2002, All rights reserved
//
// THIS CODE AND INFORMATION IS PROVIDED "AS IS" WITHOUT WARRANTY OF 
// ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED TO 
// THE IMPLIED WARRANTIES OF MERCHANTABILITY AND/OR FITNESS FOR A 
// PARTICULAR PURPOSE.
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#ifndef _EVENTLOG_CPP
#define _EVENTLOG_CPP
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#include <Windows.H>
#include <Stdio.H>
#include <Stdlib.H>

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#define _EVENT_LOG_BUILD 1

#include "Debug.H"
#include "../SharedSource/NSWFL.H"
#include "Common.H"
#include "EventLog.H"

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

bool RecordWarn(const char *sMsg)
{
	return RecordEvent(EVENTLOG_WARNING_TYPE, MSG_BASIC_WARNING, 0, sMsg);
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

bool RecordError(const char *sMsg)
{
	return RecordEvent(EVENTLOG_ERROR_TYPE, MSG_BASIC_FAILURE, 0, sMsg);
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

bool RecordInfo(const char *sMsg)
{
	return RecordEvent(EVENTLOG_INFORMATION_TYPE, MSG_BASIC_INFORMATION, 0, sMsg);
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

bool RecordEvent(WORD dwEventType, DWORD dwEventID, WORD wCategory, const char *sMsg)
{
    HANDLE hEventSource = NULL; 

	char *sStrings[1];
	int iStrings = 0;

    if((hEventSource = RegisterEventSource(NULL, gsEventName)) == NULL)
    {
        printf("Could not register the event source.\n"); 
        return false;
    }

	if(*sMsg != NULL)
	{
		iStrings++;
	}

	sStrings[0] = (char *) sMsg;

	if (!ReportEvent(hEventSource,      // event log handle 
            dwEventType,                // event type 
            wCategory,                  // event category  
            dwEventID,                  // event identifier 
            NULL,                       // no user security identifier 
            iStrings,                   // number of substitution strings 
            0,                          // no data 
            (LPCTSTR*) &sStrings[0],    // pointer to strings 
            NULL))                      // no data 
    {
		char sErr[1024];
		sprintf_s(sErr, sizeof(sErr), "ERROR! Could not report event. (Error Number: %d)", GetLastError()); 
		WriteSysLogEx(sErr, EVENT_NONE);
    }

    DeregisterEventSource(hEventSource); 
    return true;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
#endif
